unit CompEllipse;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tEllipse = class(tDrawComponent)
  private
  public
    Filled: Boolean;
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    procedure GetExtent(var aMin, aMax: tPoint); override;
    function GetRgn: hRgn; override;
    procedure Paint; override;
    procedure SetPropList; override;
  end;
var dciEllipse: Integer;

implementation

uses Dialogs, SysUtils,
     GDIPAPI, GDIPOBJ;

constructor tEllipse.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 13;
  inherited CreateByBasicName(aOwner, 'Ellipse');
  Color:= clMoneyGreen;
  CreatingByAddPoint:= True;
end;

constructor tEllipse.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

procedure tEllipse.GetExtent(var aMin, aMax: Windows.tPoint);
var i: Integer;
begin
  if Left< aMin.X then aMin.X:= Left;
  if (Left+ Width)> aMax.X then aMax.X:= Left+ Width;
  if Top< aMin.Y then aMin.Y:= Top;
  if (Top+ Height)> aMax.Y then aMax.Y:= Top+ Height;
  for i:= 0 to ComponentCount- 1 do
    tDrawComponent(Components[i]).GetExtent(aMin, aMax);
end;

function tEllipse.GetRgn: hRgn;
var R1, R2: TGPRegion;
    myGraphic : TGPGraphics;
    P1, P2: TGPGraphicsPath;
//    SolidBrush: TGPSolidBrush;
    L, T, W, H: Integer;
begin
  if Filled
  then
    Result:= CreateEllipticRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y)
  else
  begin
    L:= Left;
    W:= Width;
    T:= Top;
    H:= Height;
    if Width< 0 then
    begin
      L:= Left+ Width;
      W:= -Width;
    end;
    if Height< 0 then
    begin
      T:= Top+ Height;
      H:= -Height;
    end;
    myGraphic := TGPGraphics.Create(DrawFace.Canvas.Handle);
    P1:= TGPGraphicsPath.Create;
    P1.AddEllipse(Round(L* DrawFace.ZoomFactor)- DrawFace.Shift.X- 2,
            Round(T* DrawFace.ZoomFactor)- DrawFace.Shift.Y- 2,
            Round(W* DrawFace.ZoomFactor)+ 4,
            Round(H* DrawFace.ZoomFactor)+ 4);
    R1:= TGPRegion.Create(P1);
    P2:= TGPGraphicsPath.Create;
    P2.AddEllipse(Round(L* DrawFace.ZoomFactor)- DrawFace.Shift.X+ 2,
            Round(T* DrawFace.ZoomFactor)- DrawFace.Shift.Y+ 2,
            Round(W* DrawFace.ZoomFactor)- 4,
            Round(H* DrawFace.ZoomFactor)- 4);
    R2:= TGPRegion.Create(P2);
    R1.Exclude(R2);
//  SolidBrush:= TGPSolidBrush.Create(MakeColor(144, 0, 144, 144));
//  myGraphic.FillRegion(SolidBrush, R1);
//  SolidBrush.Free;
    Result:= R1.GetHRGN(myGraphic);
    P1.Free;
    P2.Free;
    R1.Free;
    R2.Free;
    myGraphic.Free;
  end;
end;

procedure tEllipse.Paint;
begin
  with DrawFace.Canvas do
  begin
    Brush.Color:= Color;
    if Filled then Brush.Style:= bsSolid
              else Brush.Style:= bsClear;
    Pen.Width:= Round(DrawFace.ZoomFactor* LineWidth);
    if Pen.Width< 1 then Pen.Width:= 1;
    if DrawFace.Printing then Pen.Color:= clBlack
                          else Pen.Color:= LineColor;
    Ellipse(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top * DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
  end;
  inherited;
end;

procedure tEllipse.SetPropList;
begin
  inherited;
  with PropList do
  begin
    Add(tBooleanProp.CreateBooleanProp(@Filled, 'Filled'));
  end;
end;

initialization

  //dci -> DrawComponentIndex

  dciEllipse:= Face.DrawCompItemList.Add(tDrawCompItem.Create('Ellipse', tEllipse));

end.
